/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import mlsoft.mct.MlEventMulticaster;
import mlsoft.mct.MlPanel;
import mlsoft.mct.MlResource;
import mlsoft.mct.MlResources;
import mlsoft.mct.MlSegment;
import mlsoft.mct.MlTab;
import mlsoft.mct.MlTabPanelEvent;
import mlsoft.mct.MlTabPanelEventHandler;
import mlsoft.mct.MlTabPanelListener;
import mlsoft.mct.MlTabPanelResourceMap;
import mlsoft.mct.MlTabRow;
import mlsoft.mct.MlUtil;

public class MlTabPanel
extends MlPanel {
    public static final int CORNER_NONE = 0;
    public static final int CORNER_LINE = 1;
    public static final int CORNER_ARC = 2;
    public static final int TABS_ON_TOP = 0;
    public static final int TABS_ON_BOTTOM = 1;
    public static final int TABS_ON_LEFT = 2;
    public static final int TABS_ON_RIGHT = 3;
    private static MlTabPanelResourceMap _tabPanelResMap;
    private static final int MAX_TAB_ROWS = 32;
    private static final int GC_SHADOWBOT = 0;
    private static final int GC_SHADOWTOP = 1;
    private static final int GC_BLANK = 2;
    private static final int GC_UNSET = 3;
    protected static final long tabFont_BIT = 1L;
    protected static final long tabInactiveImage_BIT = 2L;
    protected static final long tabImage_BIT = 4L;
    protected static final long tabLabel_BIT = 8L;
    protected String _tab;
    protected Font _tabFont;
    protected Image _tabInactiveImage;
    protected Image _tabImage;
    protected String _tabLabel;
    protected MlTab _activeTab;
    protected boolean _allowLayout;
    protected int _activeRow;
    protected Graphics _drawGC;
    protected boolean _focusIn;
    protected MlTab _focusTab;
    protected boolean _serverDrawsArcsLarge;
    protected int _tabAllocCount;
    protected int _tabHeight;
    protected int _tabWidth;
    protected MlTab[] _tabs;
    protected MlTabPanelEventHandler _handler;
    protected MlTabPanelListener _tabPanelListener;
    protected int _activeTabNum;
    protected boolean _autoSelect;
    protected Color _blankBackground;
    protected Color _bottomShadowColor;
    protected int _cornerDimension;
    protected int _cornerStyle;
    protected int _debugLevel;
    protected Color _highlightColor;
    protected int _highlightThickness;
    protected Color _inactiveBackground;
    protected Color _inactiveForeground;
    protected int _marginHeight;
    protected int _marginWidth;
    protected int _imageMargin;
    protected int _shadowThickness;
    protected int _spacing;
    protected int _tabBarHeight;
    protected int _tabCount;
    protected int _tabPlacement;
    protected int _tabsPerRow;
    protected Color _topShadowColor;
    private int _pageCount;

    private static synchronized void initResourceMap() {
        if (_tabPanelResMap != null) {
            return;
        }
        _tabPanelResMap = new MlTabPanelResourceMap();
    }

    public MlTabPanel() {
        MlTabPanel.initResourceMap();
        this._resourceMap = _tabPanelResMap;
        this.setLayout(new CardLayout());
        this.setComponentFont(new Font("Helvetica", 0, 12));
        this.setComponentBackground(new Color(192, 192, 192));
        this.initTabPanelProperties();
        this._tab = null;
        this._tabFont = null;
        this._tabInactiveImage = null;
        this._tabImage = null;
        this._tabLabel = null;
        this._activeTab = null;
        this._allowLayout = true;
        this._activeRow = -1;
        this._drawGC = null;
        this._focusIn = false;
        this._focusTab = null;
        this._serverDrawsArcsLarge = true;
        this._tabAllocCount = 32;
        this._tabHeight = 0;
        this._tabWidth = 0;
        this._tabs = new MlTab[this._tabAllocCount];
        this._handler = new MlTabPanelEventHandler(this);
        this.addKeyListener(this._handler);
        this.addMouseListener(this._handler);
        this.addFocusListener(this._handler);
    }

    public void addNotify() {
        super.addNotify();
        if (this._autoSelect && this._tabCount > 0) {
            this.showPage(0, false);
        }
    }

    protected void select(MouseEvent mouseEvent) {
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: ButtonPress " + mouseEvent.getX() + " " + mouseEvent.getY());
        }
        int n = 0;
        while (n < this._tabCount) {
            MlTab mlTab = this._tabs[n];
            Rectangle rectangle = this.getTabRect(mlTab, false);
            if (mouseEvent.getX() > rectangle.x && mouseEvent.getX() < rectangle.x + rectangle.width && mouseEvent.getY() > rectangle.y && mouseEvent.getY() < rectangle.y + rectangle.height) {
                if (this._debugLevel > 0) {
                    System.out.println("TabPanel: pressed tab " + n);
                }
                this.showPage(mlTab, true);
                this.setFocusTab(mlTab, mouseEvent);
                return;
            }
            ++n;
        }
    }

    public synchronized void drawView(Graphics graphics, Rectangle rectangle) {
        if (graphics == null) {
            return;
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
        graphics = graphics.create();
        graphics.setClip(0, 0, rectangle.width, rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        int n = this._shadowThickness;
        int n2 = this._highlightThickness;
        if (this._tabPlacement == 0) {
            rectangle2.x = 0;
            rectangle2.y = this._tabHeight;
            rectangle2.width = this.getBounds().width;
            rectangle2.height = this.getBounds().height - this._tabHeight;
        } else if (this._tabPlacement == 1) {
            rectangle2.x = 0;
            rectangle2.y = 0;
            rectangle2.width = this.getBounds().width;
            rectangle2.height = this.getBounds().height - this._tabHeight;
        }
        if (this._tabPlacement == 2) {
            rectangle2.x = this._tabWidth;
            rectangle2.y = 0;
            rectangle2.width = this.getBounds().width - this._tabWidth;
            rectangle2.height = this.getBounds().height;
        }
        if (this._tabPlacement == 3) {
            rectangle2.x = 0;
            rectangle2.y = 0;
            rectangle2.width = this.getBounds().width - this._tabWidth;
            rectangle2.height = this.getBounds().height;
        }
        if (MlUtil.rectIntersect(rectangle, rectangle2) != 0) {
            if (this._tabPlacement == 0 || this._tabPlacement == 1) {
                this.drawOuterShadowTopBottom(graphics, rectangle2);
            } else {
                this.drawOuterShadowLeftRight(graphics, rectangle2);
            }
            rectangle2.x += n;
            rectangle2.y += n;
            rectangle2.width -= n * 2;
            rectangle2.height -= n * 2;
            if (rectangle2.width >= 0 && rectangle2.height >= 0) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        if (this._tabCount == 0) {
            graphics.dispose();
            return;
        }
        rectangle2.x = 0;
        rectangle2.y = 0;
        rectangle2.width = 0;
        rectangle2.height = 0;
        int n3 = 0;
        while (n3 < this._tabCount) {
            MlTab mlTab = this._tabs[n3];
            rectangle2 = this.getTabRect(mlTab, false);
            Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (this._tabPlacement == 0 || this._tabPlacement == 1) {
                rectangle3.width += this._spacing;
            } else {
                rectangle3.height += this._spacing;
            }
            if (this._tabsPerRow > 0) {
                if (rectangle2.x == 2) {
                    rectangle3.x = 0;
                }
                if (rectangle2.y == 2) {
                    rectangle3.y = 0;
                }
                if (rectangle2.x + rectangle2.width == this.getBounds().width - 2) {
                    rectangle3.width += 2;
                }
                if (rectangle2.y + rectangle2.height == this.getBounds().height - 2) {
                    rectangle3.height += 2;
                }
            }
            if (MlUtil.rectIntersect(rectangle, rectangle3) != 0) {
                if (this._debugLevel > 1) {
                    System.out.println("TabPanel: paint tab " + n3);
                }
                if (mlTab == this._activeTab) {
                    graphics.setColor(this.getBackground());
                } else {
                    graphics.setColor(this._inactiveBackground);
                }
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this._tabPlacement == 0 || this._tabPlacement == 1) {
                    if (this._cornerStyle == 1) {
                        this.drawTabShadowLineTopBottom(graphics, mlTab);
                    } else if (this._cornerStyle == 2) {
                        this.drawTabShadowArcTopBottom(graphics, mlTab);
                    } else {
                        this.drawTabShadowNoneTopBottom(graphics, mlTab);
                    }
                } else if (this._cornerStyle == 1) {
                    this.drawTabShadowLineLeftRight(graphics, mlTab);
                } else if (this._cornerStyle == 2) {
                    this.drawTabShadowArcLeftRight(graphics, mlTab);
                } else {
                    this.drawTabShadowNoneLeftRight(graphics, mlTab);
                }
                if (mlTab.label != null) {
                    this.drawTabLabel(graphics, mlTab);
                }
                if (mlTab == this._activeTab && mlTab.image != null && (mlTab.maxImageWidth > 0 || mlTab.maxImageHeight > 0)) {
                    this.drawTabImage(graphics, mlTab, true);
                } else if (mlTab != this._activeTab && mlTab.inactiveImage != null && (mlTab.maxImageWidth > 0 || mlTab.maxImageHeight > 0)) {
                    this.drawTabImage(graphics, mlTab, false);
                }
                this.drawTabHighlight(graphics, mlTab);
                this.setDrawStyle(graphics, 2);
                if (this._tabsPerRow > 0) {
                    if (rectangle2.x == 2) {
                        rectangle3.x = 0;
                        rectangle3.y = rectangle2.y;
                        rectangle3.width = 2;
                        rectangle3.height = rectangle2.height;
                        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                    if (rectangle2.y == 2) {
                        rectangle3.x = rectangle2.x;
                        rectangle3.y = 0;
                        rectangle3.width = rectangle2.width;
                        rectangle3.height = 2;
                        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                    if (rectangle2.x + rectangle2.width == this.getBounds().width - 2) {
                        rectangle3.x = this.getBounds().width - 2;
                        rectangle3.y = rectangle2.y;
                        rectangle3.width = 2;
                        rectangle3.height = rectangle2.height;
                        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                    if (rectangle2.y + rectangle2.height == this.getBounds().height - 2) {
                        rectangle3.x = rectangle2.x;
                        rectangle3.y = this.getBounds().height - 2;
                        rectangle3.width = rectangle2.width;
                        rectangle3.height = 2;
                        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                }
                if (this._spacing > 0) {
                    if (this._tabPlacement == 0 || this._tabPlacement == 1) {
                        graphics.fillRect(rectangle2.x + rectangle2.width, rectangle2.y, this._spacing, rectangle2.height);
                    } else {
                        graphics.fillRect(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, this._spacing);
                    }
                }
                this.setDrawStyle(graphics, 3);
            }
            ++n3;
        }
        if (this._tabsPerRow == 0) {
            if (this._tabPlacement == 0 || this._tabPlacement == 1) {
                rectangle2.x += rectangle2.width + this._spacing;
                if (this.getBounds().width > rectangle2.x) {
                    rectangle2.y = this._tabPlacement == 0 ? 0 : this.getBounds().height - this._tabHeight;
                    rectangle2.width = this.getBounds().width - rectangle2.x;
                    rectangle2.height = this._tabHeight;
                    this.setDrawStyle(graphics, 2);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    this.setDrawStyle(graphics, 3);
                }
            } else {
                rectangle2.y += rectangle2.height + this._spacing;
                if (this.getBounds().height > rectangle2.y) {
                    rectangle2.x = this._tabPlacement == 2 ? 0 : this.getBounds().width - this._tabWidth;
                    rectangle2.width = this._tabWidth;
                    rectangle2.height = this.getBounds().height - rectangle2.y;
                    this.setDrawStyle(graphics, 2);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    this.setDrawStyle(graphics, 3);
                }
            }
        }
        graphics.dispose();
    }

    public synchronized void doLayout() {
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: layout");
        }
        this.doLayout(false);
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: super layout start");
        }
        super.doLayout();
    }

    public Insets insets() {
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: insets");
        }
        int n = this._shadowThickness;
        int n2 = this._shadowThickness;
        int n3 = this._shadowThickness;
        int n4 = this._shadowThickness;
        switch (this._tabPlacement) {
            case 2: {
                n += this._tabBarHeight;
                break;
            }
            case 3: {
                n2 += this._tabBarHeight;
                break;
            }
            case 0: {
                n3 += this._tabBarHeight;
                break;
            }
            case 1: {
                n4 += this._tabBarHeight;
            }
        }
        return new Insets(n3, n, n4, n2);
    }

    protected void doLayout(boolean bl) {
        if (!this._allowLayout) {
            return;
        }
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: internal layout start");
        }
        this._allowLayout = false;
        if (this._tabPlacement == 2 || this._tabPlacement == 3) {
            this.layoutLeftRight(bl);
        } else {
            this.layoutTopBottom(bl);
        }
        this._allowLayout = true;
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: internal layout done");
        }
    }

    protected void layoutTopBottom(boolean bl) {
        MlTab mlTab;
        int n = this._shadowThickness;
        int n2 = this._highlightThickness;
        MlTabRow[] mlTabRowArray = new MlTabRow[32];
        int n3 = 0;
        while (n3 < 32) {
            mlTabRowArray[n3] = new MlTabRow();
            ++n3;
        }
        int n4 = this._cornerStyle == 1 ? (int)((double)this._cornerDimension * 0.5 + 0.99) : (this._cornerStyle == 2 ? (int)((double)this._cornerDimension * 0.3 + 0.99) : 0);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        n3 = 0;
        while (n3 < this._tabCount) {
            int n11;
            mlTab = this._tabs[n3];
            mlTab.firstInRow = false;
            if (n9 == 0) {
                mlTab.firstInRow = true;
            }
            if (this._tabsPerRow > 0 && n9 == this._tabsPerRow) {
                mlTab.firstInRow = true;
                if (n5 > 0) {
                    n5 -= this._spacing;
                }
                mlTabRowArray[n8].y = n6;
                mlTabRowArray[n8].width = n5;
                mlTabRowArray[n8].height = n7;
                mlTabRowArray[n8].numTabs = n9;
                if (this._debugLevel > 0) {
                    System.out.println("TabPanel: row " + n8 + " y " + n6 + " w " + n5 + " h " + n7 + " numTabs " + n9);
                }
                n6 += n7;
                n7 = 0;
                if (n5 > n10) {
                    n10 = n5;
                }
                n5 = 0;
                n9 = 0;
                if (++n8 == 31) {
                    this.warning("TabPanel: Layout ERROR - too many rows");
                    return;
                }
            }
            if ((n11 = n4 + n + mlTab.labelHeight + this._marginHeight * 2 + n2 * 2) > n7) {
                n7 = n11;
            }
            if (mlTab.image != null && (n11 = n4 + n + mlTab.imageHeight + this._marginHeight * 2 + n2 * 2) > n7) {
                n7 = n11;
            }
            if (mlTab.inactiveImage != null && (n11 = n4 + n + mlTab.inactiveImageHeight + this._marginHeight * 2 + n2 * 2) > n7) {
                n7 = n11;
            }
            n5 += n * 2 + n4 * 2 + this._marginWidth * 2 + n2 * 2 + mlTab.labelWidth;
            if (mlTab.maxImageWidth > 0) {
                n5 += mlTab.maxImageWidth + this._imageMargin;
            }
            n5 += this._spacing;
            ++n9;
            mlTab.row = n8;
            ++n3;
        }
        if (n5 > 0) {
            n5 -= this._spacing;
        }
        mlTabRowArray[n8].y = n6;
        mlTabRowArray[n8].width = n5;
        mlTabRowArray[n8].height = n7;
        mlTabRowArray[n8].numTabs = n9;
        int n12 = n8 + 1;
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: row " + n8 + " y " + n6 + " w " + n5 + " h " + n7 + " numTabs " + n9);
        }
        this._tabBarHeight = this._tabHeight = n6 + n7;
        int n13 = this._tabHeight;
        if (n10 < n5) {
            n10 = n5;
        }
        if (this._tabsPerRow > 0 && n10 > 0) {
            n10 += 4;
        }
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: min w " + n10 + " h " + n13);
        }
        if (this._activeTab != null) {
            this._activeRow = n8 = this._activeTab.row;
            mlTabRowArray[n8].y = this._tabHeight - mlTabRowArray[n8].height;
            n3 = n8 + 1;
            while (n3 < n12) {
                mlTabRowArray[n3].y -= mlTabRowArray[n8].height;
                ++n3;
            }
        } else {
            this._activeRow = -1;
        }
        int n14 = 0;
        n3 = 0;
        while (n3 < this._tabCount) {
            int n15;
            mlTab = this._tabs[n3];
            n8 = mlTab.row;
            if (mlTab.firstInRow) {
                n14 = this._tabsPerRow > 0 && n8 != this._activeRow ? 2 : 0;
            }
            mlTab.x = n14;
            n14 += n + n4 + this._marginWidth + n2;
            if (mlTab.maxImageWidth > 0) {
                n14 += mlTab.maxImageWidth + this._imageMargin;
            }
            mlTab.height = mlTabRowArray[n8].height;
            if (this._tabPlacement == 0) {
                mlTab.y = mlTabRowArray[n8].y;
                n15 = mlTab.y + mlTab.height - this._marginHeight - n2 - mlTab.labelHeight;
            } else {
                mlTab.y = this.getBounds().height - mlTabRowArray[n8].y - mlTabRowArray[n8].height;
                n15 = mlTab.y + this._marginHeight + n2;
            }
            int n16 = 0;
            int n17 = 0;
            int n18 = this.getBounds().width - mlTabRowArray[n8].width;
            if (n8 != this._activeRow) {
                n18 -= 4;
            }
            if (this._tabsPerRow > 0 && n18 > 0) {
                n17 = n16 = n18 / (mlTabRowArray[n8].numTabs * 2);
                if (mlTab.firstInRow) {
                    n17 += n18 - n16 * mlTabRowArray[n8].numTabs * 2;
                }
            }
            mlTab.labelX = n14 += n16;
            mlTab.labelY = n15;
            mlTab.width = (n14 += n17 + mlTab.labelWidth + n2 + this._marginWidth + n4 + n) - mlTab.x;
            n14 += this._spacing;
            ++n3;
        }
    }

    protected void layoutLeftRight(boolean bl) {
        MlTab mlTab;
        int n = this._shadowThickness;
        int n2 = this._highlightThickness;
        MlTabRow[] mlTabRowArray = new MlTabRow[32];
        int n3 = 0;
        while (n3 < 32) {
            mlTabRowArray[n3] = new MlTabRow();
            ++n3;
        }
        int n4 = this._cornerStyle == 1 ? (int)((double)this._cornerDimension * 0.5 + 0.99) : (this._cornerStyle == 2 ? (int)((double)this._cornerDimension * 0.3 + 0.99) : 0);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        n3 = 0;
        while (n3 < this._tabCount) {
            int n11;
            mlTab = this._tabs[n3];
            mlTab.firstInRow = false;
            if (n9 == 0) {
                mlTab.firstInRow = true;
            }
            if (this._tabsPerRow > 0 && n9 == this._tabsPerRow) {
                mlTab.firstInRow = true;
                if (n6 > 0) {
                    n6 -= this._spacing;
                }
                mlTabRowArray[n8].x = n5;
                mlTabRowArray[n8].height = n6;
                mlTabRowArray[n8].width = n7;
                mlTabRowArray[n8].numTabs = n9;
                if (this._debugLevel > 0) {
                    System.out.println("TabPanel: row " + n8 + " x " + n5 + " w " + n7 + " h " + n6 + " numTabs " + n9);
                }
                n5 += n7;
                n7 = 0;
                if (n6 > n10) {
                    n10 = n6;
                }
                n6 = 0;
                n9 = 0;
                if (++n8 == 31) {
                    this.warning("TabPanel: Layout ERROR - too many rows");
                    return;
                }
            }
            if ((n11 = n4 + n + mlTab.labelWidth + this._marginHeight * 2 + n2 * 2) > n7) {
                n7 = n11;
            }
            if (mlTab.image != null && (n11 = n4 + n + mlTab.imageWidth + this._marginHeight * 2 + n2 * 2) > n7) {
                n7 = n11;
            }
            if (mlTab.inactiveImage != null && (n11 = n4 + n + mlTab.inactiveImageWidth + this._marginHeight * 2 + n2 * 2) > n7) {
                n7 = n11;
            }
            n6 += n * 2 + n4 * 2 + this._marginWidth * 2 + n2 * 2 + mlTab.labelHeight;
            if (mlTab.maxImageHeight > 0) {
                n6 += mlTab.maxImageHeight + this._imageMargin;
            }
            n6 += this._spacing;
            ++n9;
            mlTab.row = n8;
            ++n3;
        }
        if (n6 > 0) {
            n6 -= this._spacing;
        }
        mlTabRowArray[n8].x = n5;
        mlTabRowArray[n8].height = n6;
        mlTabRowArray[n8].width = n7;
        mlTabRowArray[n8].numTabs = n9;
        int n12 = n8 + 1;
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: row " + n8 + " x " + n5 + " w " + n7 + " h " + n6 + " numTabs " + n9);
        }
        this._tabBarHeight = this._tabWidth = n5 + n7;
        int n13 = this._tabWidth;
        if (n10 < n6) {
            n10 = n6;
        }
        if (this._tabsPerRow > 0 && n10 > 0) {
            n10 += 4;
        }
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: min w " + n13 + " h " + n10);
        }
        if (this._activeTab != null) {
            this._activeRow = n8 = this._activeTab.row;
            mlTabRowArray[n8].x = this._tabWidth - mlTabRowArray[n8].width;
            n3 = n8 + 1;
            while (n3 < n12) {
                mlTabRowArray[n3].x -= mlTabRowArray[n8].width;
                ++n3;
            }
        } else {
            this._activeRow = -1;
        }
        int n14 = 0;
        n3 = 0;
        while (n3 < this._tabCount) {
            int n15;
            mlTab = this._tabs[n3];
            n8 = mlTab.row;
            if (mlTab.firstInRow) {
                n14 = this._tabsPerRow > 0 && n8 != this._activeRow ? 2 : 0;
            }
            mlTab.y = n14;
            n14 += n + n4 + this._marginWidth + n2;
            if (mlTab.maxImageHeight > 0) {
                n14 += mlTab.maxImageHeight + this._imageMargin;
            }
            mlTab.width = mlTabRowArray[n8].width;
            if (this._tabPlacement == 2) {
                mlTab.x = mlTabRowArray[n8].x;
                n15 = mlTab.x + mlTab.width - this._marginHeight - n2 - mlTab.labelWidth;
            } else {
                mlTab.x = this.getBounds().width - mlTabRowArray[n8].x - mlTabRowArray[n8].width;
                n15 = mlTab.x + this._marginHeight + n2;
            }
            int n16 = 0;
            int n17 = 0;
            int n18 = this.getBounds().height - mlTabRowArray[n8].height;
            if (n8 != this._activeRow) {
                n18 -= 4;
            }
            if (this._tabsPerRow > 0 && n18 > 0) {
                n17 = n16 = n18 / (mlTabRowArray[n8].numTabs * 2);
                if (mlTab.firstInRow) {
                    n17 += n18 - n16 * mlTabRowArray[n8].numTabs * 2;
                }
            }
            mlTab.labelX = n15;
            mlTab.labelY = n14 += n16;
            mlTab.height = (n14 += n17 + mlTab.labelHeight + n2 + this._marginWidth + n4 + n) - mlTab.y;
            n14 += this._spacing;
            ++n3;
        }
    }

    protected Rectangle getTabRect(MlTab mlTab, boolean bl) {
        Rectangle rectangle = new Rectangle();
        int n = this._shadowThickness;
        rectangle.x = mlTab.x;
        rectangle.y = mlTab.y;
        rectangle.width = mlTab.width;
        rectangle.height = mlTab.height;
        if (bl) {
            if (this._tabPlacement == 0) {
                rectangle.height += n;
            } else if (this._tabPlacement == 1) {
                rectangle.y -= n;
                rectangle.height += n;
            } else if (this._tabPlacement == 2) {
                rectangle.width += n;
            } else {
                rectangle.x -= n;
                rectangle.width += n;
            }
        }
        return rectangle;
    }

    protected void drawTabLabel(Graphics graphics, MlTab mlTab) {
        if (this._activeTab == mlTab) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor(this._inactiveForeground);
        }
        Rectangle rectangle = new Rectangle(mlTab.labelX, mlTab.labelY, mlTab.labelWidth, mlTab.labelHeight);
        MlUtil.drawString(graphics, mlTab.label, mlTab.font, 1, rectangle, rectangle);
    }

    protected void drawTabImage(Graphics graphics, MlTab mlTab, boolean bl) {
        Image image;
        int n;
        int n2;
        int n3 = this._highlightThickness;
        if (bl) {
            n2 = mlTab.imageWidth;
            n = mlTab.imageHeight;
            image = mlTab.image;
        } else {
            n2 = mlTab.inactiveImageWidth;
            n = mlTab.inactiveImageHeight;
            image = mlTab.inactiveImage;
        }
        int n4 = 0;
        int n5 = 0;
        if (this._tabPlacement == 0) {
            n4 = mlTab.labelX - n2 - n3 - this._imageMargin;
            n5 = mlTab.labelY + mlTab.labelHeight - n;
        } else if (this._tabPlacement == 1) {
            n4 = mlTab.labelX - mlTab.imageWidth - n3 - this._imageMargin;
            n5 = mlTab.labelY;
        } else if (this._tabPlacement == 2) {
            n4 = mlTab.labelX + mlTab.labelWidth - n2;
            n5 = mlTab.labelY - n - this._imageMargin - n3;
        } else if (this._tabPlacement == 3) {
            n4 = mlTab.labelX;
            n5 = mlTab.labelY - n - this._imageMargin - n3;
        }
        graphics.drawImage(image, n4, n5, this);
    }

    protected void drawTabHighlight(Graphics graphics, MlTab mlTab) {
        if (graphics == null) {
            return;
        }
        Color color = this._focusTab == mlTab && this._focusIn ? this._highlightColor : (this._activeTab == mlTab ? this.getBackground() : this._inactiveBackground);
        int n = this._highlightThickness;
        MlUtil.drawShadow(graphics, mlTab.labelX - n, mlTab.labelY - n, mlTab.labelWidth + n * 2, mlTab.labelHeight + n * 2, n, color, color);
    }

    protected void drawOuterShadowTopBottom(Graphics graphics, Rectangle rectangle) {
        int n = this._shadowThickness;
        if (n == 0) {
            return;
        }
        int n2 = this.getBounds().height - this._tabHeight - 1;
        MlSegment[] mlSegmentArray = new MlSegment[n * 2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n * 2];
        int n3 = 0;
        while (n3 < n * 2) {
            mlSegmentArray[n3] = new MlSegment();
            mlSegmentArray2[n3] = new MlSegment();
            ++n3;
        }
        MlSegment[] mlSegmentArray3 = new MlSegment[n];
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray3[n3] = new MlSegment();
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        if (this._activeTab != null) {
            n3 = 0;
            while (n3 < n) {
                mlSegmentArray[n4].x1 = rectangle.x + n3;
                mlSegmentArray[n4].y1 = rectangle.y + n3;
                mlSegmentArray[n4].x2 = this._activeTab.x + n3;
                mlSegmentArray[n4].y2 = rectangle.y + n3;
                if (rectangle.x != this._activeTab.x) {
                    ++n4;
                }
                mlSegmentArray3[n5].x1 = this._activeTab.x + n3 + 1;
                mlSegmentArray3[n5].y1 = rectangle.y + n3;
                mlSegmentArray3[n5].x2 = rectangle.x + this._activeTab.x + this._activeTab.width - n3 - 2;
                mlSegmentArray3[n5].y2 = rectangle.y + n3;
                ++n5;
                mlSegmentArray[n4].x1 = rectangle.x + this._activeTab.x + this._activeTab.width - n3 - 1;
                mlSegmentArray[n4].y1 = rectangle.y + n3;
                mlSegmentArray[n4].x2 = rectangle.x + rectangle.width - n3 - 1;
                mlSegmentArray[n4].y2 = rectangle.y + n3;
                if (this._activeTab.x + this._activeTab.width != rectangle.width) {
                    ++n4;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n) {
                mlSegmentArray[n4].x1 = rectangle.x + n3;
                mlSegmentArray[n4].y1 = rectangle.y + n3;
                mlSegmentArray[n4].x2 = rectangle.x + rectangle.width - n3 - 1;
                mlSegmentArray[n4].y2 = rectangle.y + n3;
                ++n4;
                ++n3;
            }
        }
        if (this._tabPlacement == 1) {
            n3 = 0;
            while (n3 < n4) {
                mlSegmentArray[n3].y1 = n2 - mlSegmentArray[n3].y1;
                mlSegmentArray[n3].y2 = n2 - mlSegmentArray[n3].y2;
                ++n3;
            }
            n3 = 0;
            while (n3 < n5) {
                mlSegmentArray3[n3].y1 = n2 - mlSegmentArray3[n3].y1;
                mlSegmentArray3[n3].y2 = n2 - mlSegmentArray3[n3].y2;
                ++n3;
            }
        }
        if (n4 > 0) {
            if (this._tabPlacement == 1) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        if (n5 > 0) {
            graphics.setColor(this.getBackground());
            MlUtil.drawSegments(graphics, mlSegmentArray3, n5);
        }
        n4 = 0;
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray[n4].x1 = rectangle.x + n3;
            mlSegmentArray[n4].y1 = rectangle.y + n3;
            mlSegmentArray[n4].x2 = rectangle.x + n3;
            mlSegmentArray[n4].y2 = rectangle.y + rectangle.height - n3 - 1;
            ++n4;
            ++n3;
        }
        if (n4 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        int n6 = 0;
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray2[n6].x1 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray2[n6].y1 = rectangle.y + n3;
            mlSegmentArray2[n6].x2 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray2[n6].y2 = rectangle.y + rectangle.height - n3 - 1;
            ++n6;
            ++n3;
        }
        if (n6 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n6);
            this.setDrawStyle(graphics, 3);
        }
        n6 = 0;
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray2[n6].x1 = rectangle.x + n3;
            mlSegmentArray2[n6].y1 = rectangle.y + rectangle.height - n3 - 1;
            mlSegmentArray2[n6].x2 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray2[n6].y2 = rectangle.y + rectangle.height - n3 - 1;
            if (this._tabPlacement == 1) {
                mlSegmentArray2[n6].y1 = n2 - mlSegmentArray2[n6].y1;
                mlSegmentArray2[n6].y2 = n2 - mlSegmentArray2[n6].y2;
            }
            ++n6;
            ++n3;
        }
        if (n6 > 0) {
            if (this._tabPlacement == 0) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray2, n6);
            this.setDrawStyle(graphics, 3);
        }
    }

    protected void drawOuterShadowLeftRight(Graphics graphics, Rectangle rectangle) {
        int n = this._shadowThickness;
        if (n == 0) {
            return;
        }
        int n2 = this.getBounds().width - this._tabWidth - 1;
        MlSegment[] mlSegmentArray = new MlSegment[n * 2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n * 2];
        int n3 = 0;
        while (n3 < n * 2) {
            mlSegmentArray[n3] = new MlSegment();
            mlSegmentArray2[n3] = new MlSegment();
            ++n3;
        }
        MlSegment[] mlSegmentArray3 = new MlSegment[n];
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray3[n3] = new MlSegment();
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        if (this._activeTab != null) {
            n3 = 0;
            while (n3 < n) {
                mlSegmentArray[n4].x1 = rectangle.x + n3;
                mlSegmentArray[n4].y1 = rectangle.y + n3;
                mlSegmentArray[n4].x2 = rectangle.x + n3;
                mlSegmentArray[n4].y2 = this._activeTab.y + n3;
                if (rectangle.y != this._activeTab.y) {
                    ++n4;
                }
                mlSegmentArray3[n5].x1 = rectangle.x + n3;
                mlSegmentArray3[n5].y1 = this._activeTab.y + n3 + 1;
                mlSegmentArray3[n5].x2 = rectangle.x + n3;
                mlSegmentArray3[n5].y2 = rectangle.y + this._activeTab.y + this._activeTab.height - n3 - 2;
                ++n5;
                mlSegmentArray[n4].x1 = rectangle.x + n3;
                mlSegmentArray[n4].y1 = rectangle.y + this._activeTab.y + this._activeTab.height - n3 - 1;
                mlSegmentArray[n4].x2 = rectangle.x + n3;
                mlSegmentArray[n4].y2 = rectangle.y + rectangle.height - n3 - 1;
                if (this._activeTab.y + this._activeTab.height != rectangle.height) {
                    ++n4;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n) {
                mlSegmentArray[n4].x1 = rectangle.x + n3;
                mlSegmentArray[n4].y1 = rectangle.y + n3;
                mlSegmentArray[n4].x2 = rectangle.x + n3;
                mlSegmentArray[n4].y2 = rectangle.y + rectangle.height - n3 - 1;
                ++n4;
                ++n3;
            }
        }
        if (this._tabPlacement == 3) {
            n3 = 0;
            while (n3 < n4) {
                mlSegmentArray[n3].x1 = n2 - mlSegmentArray[n3].x1;
                mlSegmentArray[n3].x2 = n2 - mlSegmentArray[n3].x2;
                ++n3;
            }
            n3 = 0;
            while (n3 < n5) {
                mlSegmentArray3[n3].x1 = n2 - mlSegmentArray3[n3].x1;
                mlSegmentArray3[n3].x2 = n2 - mlSegmentArray3[n3].x2;
                ++n3;
            }
        }
        if (n4 > 0) {
            if (this._tabPlacement == 3) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        if (n5 > 0) {
            graphics.setColor(this.getBackground());
            MlUtil.drawSegments(graphics, mlSegmentArray3, n5);
        }
        n4 = 0;
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray[n4].x1 = rectangle.x + n3;
            mlSegmentArray[n4].y1 = rectangle.y + n3;
            mlSegmentArray[n4].x2 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray[n4].y2 = rectangle.y + n3;
            ++n4;
            ++n3;
        }
        if (n4 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        int n6 = 0;
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray2[n6].x1 = rectangle.x + n3;
            mlSegmentArray2[n6].y1 = rectangle.y + rectangle.height - n3 - 1;
            mlSegmentArray2[n6].x2 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray2[n6].y2 = rectangle.y + rectangle.height - n3 - 1;
            ++n6;
            ++n3;
        }
        if (n6 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n6);
            this.setDrawStyle(graphics, 3);
        }
        n6 = 0;
        n3 = 0;
        while (n3 < n) {
            mlSegmentArray2[n6].x1 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray2[n6].y1 = rectangle.y + n3;
            mlSegmentArray2[n6].x2 = rectangle.x + rectangle.width - n3 - 1;
            mlSegmentArray2[n6].y2 = rectangle.y + rectangle.height - n3 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray2[n6].x1 = n2 - mlSegmentArray2[n6].x1;
                mlSegmentArray2[n6].x2 = n2 - mlSegmentArray2[n6].x2;
            }
            ++n6;
            ++n3;
        }
        if (n6 > 0) {
            if (this._tabPlacement == 2) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray2, n6);
            this.setDrawStyle(graphics, 3);
        }
    }

    protected void setDrawStyle(Graphics graphics, int n) {
        if (n == 0) {
            graphics.setColor(this._bottomShadowColor);
            return;
        }
        if (n == 1) {
            graphics.setColor(this._topShadowColor);
            return;
        }
        if (n == 2) {
            graphics.setColor(this._blankBackground);
        }
    }

    protected void drawTabShadowLineTopBottom(Graphics graphics, MlTab mlTab) {
        int n = 2 * mlTab.y + mlTab.height - 1;
        int n2 = this._shadowThickness;
        if (n2 == 0) {
            return;
        }
        int n3 = this._cornerDimension;
        Point[] pointArray = new Point[4];
        int n4 = 0;
        while (n4 < 4) {
            pointArray[n4] = new Point(0, 0);
            ++n4;
        }
        int n5 = 0;
        int n6 = 0;
        MlSegment[] mlSegmentArray = new MlSegment[n2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n2];
        n4 = 0;
        while (n4 < n2) {
            mlSegmentArray[n4] = new MlSegment();
            mlSegmentArray2[n4] = new MlSegment();
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            mlSegmentArray[n5].x1 = mlTab.x + n4;
            mlSegmentArray[n5].y1 = mlTab.y + n3 + n2;
            mlSegmentArray[n5].x2 = mlTab.x + n4;
            mlSegmentArray[n5].y2 = mlTab.y + mlTab.height - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray[n5].y2 += n4;
            }
            if (this._tabPlacement == 1) {
                mlSegmentArray[n5].y1 = n - mlSegmentArray[n5].y1;
                mlSegmentArray[n5].y2 = n - mlSegmentArray[n5].y2;
            }
            ++n5;
            mlSegmentArray2[n6].x1 = mlTab.x + mlTab.width - n4 - 1;
            mlSegmentArray2[n6].y1 = mlTab.y + n3 + n2;
            mlSegmentArray2[n6].x2 = mlTab.x + mlTab.width - n4 - 1;
            mlSegmentArray2[n6].y2 = mlTab.y + mlTab.height - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray2[n6].y2 += n4;
            }
            if (this._tabPlacement == 1) {
                mlSegmentArray2[n6].y1 = n - mlSegmentArray2[n6].y1;
                mlSegmentArray2[n6].y2 = n - mlSegmentArray2[n6].y2;
            }
            ++n6;
            ++n4;
        }
        if (n5 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n5);
            this.setDrawStyle(graphics, 3);
        }
        if (n6 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n6);
            this.setDrawStyle(graphics, 3);
        }
        n5 = 0;
        n4 = 0;
        while (n4 < n2) {
            mlSegmentArray[n5].x1 = mlTab.x + n3 + n2;
            mlSegmentArray[n5].y1 = mlTab.y + n4;
            mlSegmentArray[n5].x2 = mlTab.x + mlTab.width - n3 - n2 - 1;
            mlSegmentArray[n5].y2 = mlTab.y + n4;
            if (this._tabPlacement == 1) {
                mlSegmentArray[n5].y1 = n - mlSegmentArray[n5].y1;
                mlSegmentArray[n5].y2 = n - mlSegmentArray[n5].y2;
            }
            ++n5;
            ++n4;
        }
        if (n5 > 0) {
            if (this._tabPlacement == 0) {
                this.setDrawStyle(graphics, 1);
            } else {
                this.setDrawStyle(graphics, 0);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n5);
            this.setDrawStyle(graphics, 3);
        }
        pointArray[0].x = mlTab.x;
        pointArray[0].y = mlTab.y + n3 + n2 - 1;
        pointArray[1].x = mlTab.x + n3 + n2 - 1;
        pointArray[1].y = mlTab.y;
        pointArray[2].x = mlTab.x + n3 + n2 - 1;
        pointArray[2].y = mlTab.y + n3 + n2 - 1;
        if (this._tabPlacement == 1) {
            pointArray[0].y = n - pointArray[0].y;
            pointArray[1].y = n - pointArray[1].y;
            pointArray[2].y = n - pointArray[2].y;
        }
        int n7 = mlTab.y;
        if (this._tabPlacement == 1) {
            n7 = mlTab.y + mlTab.height - n3 - n2;
        }
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(mlTab.x, n7, n3 + n2, n3 + n2);
        this.setDrawStyle(graphics, 3);
        this.setDrawStyle(graphics, 1);
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
        this.setDrawStyle(graphics, 3);
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        pointArray[0].x += n2;
        pointArray[1].y += n2;
        if (this._tabPlacement == 1) {
            pointArray[1].y -= n2 * 2;
        }
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
        pointArray[0].x = mlTab.x + mlTab.width - 1;
        pointArray[0].y = mlTab.y + n3 + n2 - 1;
        pointArray[1].x = mlTab.x + mlTab.width - n3 - n2;
        pointArray[1].y = mlTab.y;
        pointArray[2].x = mlTab.x + mlTab.width - n3 - n2;
        pointArray[2].y = mlTab.y + n3 + n2 - 1;
        if (this._tabPlacement == 1) {
            pointArray[0].y = n - pointArray[0].y;
            pointArray[1].y = n - pointArray[1].y;
            pointArray[2].y = n - pointArray[2].y;
        }
        n7 = mlTab.y;
        if (this._tabPlacement == 1) {
            n7 = mlTab.y + mlTab.height - n3 - n2;
        }
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(mlTab.x + mlTab.width - n3 - n2, n7, n3 + n2, n3 + n2);
        this.setDrawStyle(graphics, 3);
        if (this._tabPlacement == 0) {
            this.setDrawStyle(graphics, 1);
        } else {
            this.setDrawStyle(graphics, 0);
        }
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
        this.setDrawStyle(graphics, 3);
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        pointArray[0].x -= n2;
        pointArray[1].y += n2;
        if (this._tabPlacement == 1) {
            pointArray[1].y -= n2 * 2;
        }
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
    }

    protected void drawTabShadowLineLeftRight(Graphics graphics, MlTab mlTab) {
        int n = 2 * mlTab.x + mlTab.width - 1;
        int n2 = this._shadowThickness;
        if (n2 == 0) {
            return;
        }
        int n3 = this._cornerDimension;
        Point[] pointArray = new Point[4];
        int n4 = 0;
        while (n4 < 4) {
            pointArray[n4] = new Point(0, 0);
            ++n4;
        }
        int n5 = 0;
        int n6 = 0;
        MlSegment[] mlSegmentArray = new MlSegment[n2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n2];
        n4 = 0;
        while (n4 < n2) {
            mlSegmentArray[n4] = new MlSegment();
            mlSegmentArray2[n4] = new MlSegment();
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            mlSegmentArray[n5].x1 = mlTab.x + n3 + n2;
            mlSegmentArray[n5].y1 = mlTab.y + n4;
            mlSegmentArray[n5].x2 = mlTab.x + mlTab.width - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray[n5].x2 += n4;
            }
            mlSegmentArray[n5].y2 = mlTab.y + n4;
            if (this._tabPlacement == 3) {
                mlSegmentArray[n5].x1 = n - mlSegmentArray[n5].x1;
                mlSegmentArray[n5].x2 = n - mlSegmentArray[n5].x2;
            }
            ++n5;
            mlSegmentArray2[n6].x1 = mlTab.x + n3 + n2;
            mlSegmentArray2[n6].y1 = mlTab.y + mlTab.height - n4 - 1;
            mlSegmentArray2[n6].x2 = mlTab.x + mlTab.width - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray2[n6].x2 += n4;
            }
            mlSegmentArray2[n6].y2 = mlTab.y + mlTab.height - n4 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray2[n6].x1 = n - mlSegmentArray2[n6].x1;
                mlSegmentArray2[n6].x2 = n - mlSegmentArray2[n6].x2;
            }
            ++n6;
            ++n4;
        }
        if (n5 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n5);
            this.setDrawStyle(graphics, 3);
        }
        if (n6 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n6);
            this.setDrawStyle(graphics, 3);
        }
        n5 = 0;
        n4 = 0;
        while (n4 < n2) {
            mlSegmentArray[n5].x1 = mlTab.x + n4;
            mlSegmentArray[n5].y1 = mlTab.y + n3 + n2;
            mlSegmentArray[n5].x2 = mlTab.x + n4;
            mlSegmentArray[n5].y2 = mlTab.y + mlTab.height - n3 - n2 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray[n5].x1 = n - mlSegmentArray[n5].x1;
                mlSegmentArray[n5].x2 = n - mlSegmentArray[n5].x2;
            }
            ++n5;
            ++n4;
        }
        if (n5 > 0) {
            if (this._tabPlacement == 2) {
                this.setDrawStyle(graphics, 1);
            } else {
                this.setDrawStyle(graphics, 0);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n5);
            this.setDrawStyle(graphics, 3);
        }
        pointArray[0].x = mlTab.x + n3 + n2 - 1;
        pointArray[0].y = mlTab.y;
        pointArray[1].x = mlTab.x;
        pointArray[1].y = mlTab.y + n3 + n2 - 1;
        pointArray[2].x = mlTab.x + n3 + n2 - 1;
        pointArray[2].y = mlTab.y + n3 + n2 - 1;
        if (this._tabPlacement == 3) {
            pointArray[0].x = n - pointArray[0].x;
            pointArray[1].x = n - pointArray[1].x;
            pointArray[2].x = n - pointArray[2].x;
        }
        int n7 = this._tabPlacement == 3 ? mlTab.x + mlTab.width - n3 - n2 : mlTab.x;
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(n7, mlTab.y, n3 + n2, n3 + n2);
        this.setDrawStyle(graphics, 3);
        this.setDrawStyle(graphics, 1);
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
        this.setDrawStyle(graphics, 3);
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        pointArray[0].y += n2;
        pointArray[1].x += n2;
        if (this._tabPlacement == 3) {
            pointArray[1].x -= n2 * 2;
        }
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
        pointArray[0].x = mlTab.x + n3 + n2 - 1;
        pointArray[0].y = mlTab.y + mlTab.height - 1;
        pointArray[1].x = mlTab.x;
        pointArray[1].y = mlTab.y + mlTab.height - n3 - n2;
        pointArray[2].x = mlTab.x + n3 + n2 - 1;
        pointArray[2].y = mlTab.y + mlTab.height - n3 - n2;
        if (this._tabPlacement == 3) {
            pointArray[0].x = n - pointArray[0].x;
            pointArray[1].x = n - pointArray[1].x;
            pointArray[2].x = n - pointArray[2].x;
        }
        n7 = this._tabPlacement == 3 ? mlTab.x + mlTab.width - n3 - n2 : mlTab.x;
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(n7, mlTab.y + mlTab.height - n3 - n2, n3 + n2, n3 + n2);
        this.setDrawStyle(graphics, 3);
        this.setDrawStyle(graphics, 0);
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
        this.setDrawStyle(graphics, 3);
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        pointArray[0].y -= n2;
        pointArray[1].x += n2;
        if (this._tabPlacement == 3) {
            pointArray[1].x -= n2 * 2;
        }
        MlUtil.fillPolygon(graphics, pointArray, 3);
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = pointArray[0].y;
        MlUtil.drawLines(graphics, pointArray, 3);
    }

    protected void drawTabShadowNoneTopBottom(Graphics graphics, MlTab mlTab) {
        int n = 2 * mlTab.y + mlTab.height - 1;
        int n2 = this._shadowThickness;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        MlSegment[] mlSegmentArray = new MlSegment[n2 * 2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n2 * 2];
        int n5 = 0;
        while (n5 < n2 * 2) {
            mlSegmentArray[n5] = new MlSegment();
            mlSegmentArray2[n5] = new MlSegment();
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            mlSegmentArray[n3].x1 = mlTab.x + n5;
            mlSegmentArray[n3].y1 = mlTab.y + n5;
            mlSegmentArray[n3].x2 = mlTab.x + n5;
            mlSegmentArray[n3].y2 = mlTab.y + mlTab.height - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray[n3].y2 += n5;
            }
            if (this._tabPlacement == 1) {
                mlSegmentArray[n3].y1 = n - mlSegmentArray[n3].y1;
                mlSegmentArray[n3].y2 = n - mlSegmentArray[n3].y2;
            }
            ++n3;
            mlSegmentArray2[n4].x1 = mlTab.x + mlTab.width - 1 - n5;
            mlSegmentArray2[n4].y1 = mlTab.y + n5;
            mlSegmentArray2[n4].x2 = mlTab.x + mlTab.width - 1 - n5;
            mlSegmentArray2[n4].y2 = mlTab.y + mlTab.height - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray2[n4].y2 += n5;
            }
            if (this._tabPlacement == 1) {
                mlSegmentArray2[n4].y1 = n - mlSegmentArray2[n4].y1;
                mlSegmentArray2[n4].y2 = n - mlSegmentArray2[n4].y2;
            }
            ++n4;
            ++n5;
        }
        if (n3 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n3);
            this.setDrawStyle(graphics, 3);
        }
        if (n4 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n4);
            this.setDrawStyle(graphics, 3);
        }
        n3 = 0;
        n5 = 0;
        while (n5 < n2) {
            mlSegmentArray[n3].x1 = mlTab.x + n5 + 1;
            mlSegmentArray[n3].y1 = mlTab.y + n5;
            mlSegmentArray[n3].x2 = mlTab.x + mlTab.width - n5 - 1;
            mlSegmentArray[n3].y2 = mlTab.y + n5;
            if (this._tabPlacement == 1) {
                mlSegmentArray[n3].y1 = n - mlSegmentArray[n3].y1;
                mlSegmentArray[n3].y2 = n - mlSegmentArray[n3].y2;
            }
            ++n3;
            ++n5;
        }
        if (n3 > 0) {
            if (this._tabPlacement == 0) {
                this.setDrawStyle(graphics, 1);
            } else {
                this.setDrawStyle(graphics, 0);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n3);
            this.setDrawStyle(graphics, 3);
        }
    }

    protected void drawTabShadowNoneLeftRight(Graphics graphics, MlTab mlTab) {
        int n = 2 * mlTab.x + mlTab.width - 1;
        int n2 = this._shadowThickness;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        MlSegment[] mlSegmentArray = new MlSegment[n2 * 2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n2 * 2];
        int n5 = 0;
        while (n5 < n2 * 2) {
            mlSegmentArray[n5] = new MlSegment();
            mlSegmentArray2[n5] = new MlSegment();
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            mlSegmentArray[n3].x1 = mlTab.x + n5;
            mlSegmentArray[n3].y1 = mlTab.y + n5;
            mlSegmentArray[n3].x2 = mlTab.x + mlTab.width - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray[n3].x2 += n5;
            }
            mlSegmentArray[n3].y2 = mlTab.y + n5;
            if (this._tabPlacement == 3) {
                mlSegmentArray[n3].x1 = n - mlSegmentArray[n3].x1;
                mlSegmentArray[n3].x2 = n - mlSegmentArray[n3].x2;
            }
            ++n3;
            mlSegmentArray2[n4].x1 = mlTab.x + n5;
            mlSegmentArray2[n4].y1 = mlTab.y + mlTab.height - n5 - 1;
            mlSegmentArray2[n4].x2 = mlTab.x + mlTab.width - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray2[n4].x2 += n5;
            }
            mlSegmentArray2[n4].y2 = mlTab.y + mlTab.height - n5 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray2[n4].x1 = n - mlSegmentArray2[n4].x1;
                mlSegmentArray2[n4].x2 = n - mlSegmentArray2[n4].x2;
            }
            ++n4;
            ++n5;
        }
        if (n3 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n3);
            this.setDrawStyle(graphics, 3);
        }
        if (n4 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n4);
            this.setDrawStyle(graphics, 3);
        }
        n3 = 0;
        n5 = 0;
        while (n5 < n2) {
            mlSegmentArray[n3].x1 = mlTab.x + n5;
            mlSegmentArray[n3].y1 = mlTab.y + n5 + 1;
            mlSegmentArray[n3].x2 = mlTab.x + n5;
            mlSegmentArray[n3].y2 = mlTab.y + mlTab.height - n5 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray[n3].x1 = n - mlSegmentArray[n3].x1;
                mlSegmentArray[n3].x2 = n - mlSegmentArray[n3].x2;
            }
            ++n3;
            ++n5;
        }
        if (n3 > 0) {
            if (this._tabPlacement == 3) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n3);
            this.setDrawStyle(graphics, 3);
        }
    }

    protected void drawTabShadowArcTopBottom(Graphics graphics, MlTab mlTab) {
        int n = 2 * mlTab.y + mlTab.height - 1;
        int n2 = this._shadowThickness;
        if (n2 == 0) {
            return;
        }
        int n3 = this._cornerDimension;
        Rectangle rectangle = new Rectangle();
        int n4 = 0;
        int n5 = 0;
        MlSegment[] mlSegmentArray = new MlSegment[n2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n2];
        int n6 = 0;
        while (n6 < n2) {
            mlSegmentArray[n6] = new MlSegment();
            mlSegmentArray2[n6] = new MlSegment();
            ++n6;
        }
        n6 = 0;
        while (n6 < n2) {
            mlSegmentArray[n4].x1 = mlTab.x + n6;
            mlSegmentArray[n4].y1 = mlTab.y + n3 + n2;
            mlSegmentArray[n4].x2 = mlTab.x + n6;
            mlSegmentArray[n4].y2 = mlTab.y + mlTab.height - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray[n4].y2 += n6;
            }
            if (this._tabPlacement == 1) {
                mlSegmentArray[n4].y1 = n - mlSegmentArray[n4].y1;
                mlSegmentArray[n4].y2 = n - mlSegmentArray[n4].y2;
            }
            ++n4;
            mlSegmentArray2[n5].x1 = mlTab.x + mlTab.width - n6 - 1;
            mlSegmentArray2[n5].y1 = mlTab.y + n3 + n2;
            mlSegmentArray2[n5].x2 = mlTab.x + mlTab.width - n6 - 1;
            mlSegmentArray2[n5].y2 = mlTab.y + mlTab.height - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray2[n5].y2 += n6;
            }
            if (this._tabPlacement == 1) {
                mlSegmentArray2[n5].y1 = n - mlSegmentArray2[n5].y1;
                mlSegmentArray2[n5].y2 = n - mlSegmentArray2[n5].y2;
            }
            ++n5;
            ++n6;
        }
        if (n4 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        if (n5 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n5);
            this.setDrawStyle(graphics, 3);
        }
        n4 = 0;
        n6 = 0;
        while (n6 < n2) {
            mlSegmentArray[n4].x1 = mlTab.x + n3 + n2;
            mlSegmentArray[n4].y1 = mlTab.y + n6;
            mlSegmentArray[n4].x2 = mlTab.x + mlTab.width - n3 - n2 - 1;
            mlSegmentArray[n4].y2 = mlTab.y + n6;
            if (this._tabPlacement == 1) {
                mlSegmentArray[n4].y1 = n - mlSegmentArray[n4].y1;
                mlSegmentArray[n4].y2 = n - mlSegmentArray[n4].y2;
            }
            ++n4;
            ++n6;
        }
        if (n4 > 0) {
            if (this._tabPlacement == 1) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        rectangle.x = mlTab.x;
        rectangle.y = mlTab.y;
        rectangle.width = n3 + n2;
        rectangle.height = n3 + n2;
        if (this._tabPlacement == 1) {
            rectangle.y = mlTab.y + mlTab.height - rectangle.height;
        }
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setDrawStyle(graphics, 3);
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        int n9 = rectangle.width * 2;
        int n10 = rectangle.height * 2;
        if (this._serverDrawsArcsLarge) {
            --n9;
            --n10;
        }
        int n11 = 0;
        int n12 = 360;
        if (this._tabPlacement == 1) {
            n8 = mlTab.y + mlTab.height - n10;
        }
        this.setDrawStyle(graphics, 1);
        Graphics graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle);
        graphics2.fillArc(n7, n8, n9, n10, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.x += n2;
        rectangle2.width -= n2;
        rectangle2.height -= n2;
        if (this._tabPlacement == 0) {
            rectangle2.y += n2;
        }
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle2);
        graphics2.fillArc(n7 += n2, n8 += n2, n9 -= n2 * 2, n10 -= n2 * 2, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
        rectangle.x = mlTab.x + mlTab.width - n3 - n2;
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setDrawStyle(graphics, 3);
        n7 = rectangle.x - n3 - n2;
        n8 = rectangle.y;
        n9 = rectangle.width * 2;
        n10 = rectangle.height * 2;
        if (this._serverDrawsArcsLarge) {
            --n9;
            --n10;
        }
        n11 = 0;
        n12 = 360;
        if (this._tabPlacement == 1) {
            n8 = mlTab.y + mlTab.height - n10;
        }
        this.setDrawStyle(graphics, 0);
        graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle);
        graphics2.fillArc(n7, n8, n9, n10, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        this.setDrawStyle(graphics, 3);
        graphics2.dispose();
        rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.width -= n2;
        rectangle2.height -= n2;
        if (this._tabPlacement == 0) {
            rectangle2.y += n2;
        }
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle2);
        graphics2.fillArc(n7 += n2, n8 += n2, n9 -= n2 * 2, n10 -= n2 * 2, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
    }

    protected void drawTabShadowArcLeftRight(Graphics graphics, MlTab mlTab) {
        int n = 2 * mlTab.x + mlTab.width - 1;
        int n2 = this._shadowThickness;
        if (n2 == 0) {
            return;
        }
        int n3 = this._cornerDimension;
        Rectangle rectangle = new Rectangle();
        int n4 = 0;
        int n5 = 0;
        MlSegment[] mlSegmentArray = new MlSegment[n2];
        MlSegment[] mlSegmentArray2 = new MlSegment[n2];
        int n6 = 0;
        while (n6 < n2) {
            mlSegmentArray[n6] = new MlSegment();
            mlSegmentArray2[n6] = new MlSegment();
            ++n6;
        }
        n6 = 0;
        while (n6 < n2) {
            mlSegmentArray[n4].x1 = mlTab.x + n3 + n2;
            mlSegmentArray[n4].y1 = mlTab.y + n6;
            mlSegmentArray[n4].x2 = mlTab.x + mlTab.width - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray[n4].x2 += n6;
            }
            mlSegmentArray[n4].y2 = mlTab.y + n6;
            if (this._tabPlacement == 3) {
                mlSegmentArray[n4].x1 = n - mlSegmentArray[n4].x1;
                mlSegmentArray[n4].x2 = n - mlSegmentArray[n4].x2;
            }
            ++n4;
            mlSegmentArray2[n5].x1 = mlTab.x + n3 + n2;
            mlSegmentArray2[n5].y1 = mlTab.y + mlTab.height - n6 - 1;
            mlSegmentArray2[n5].x2 = mlTab.x + mlTab.width - 1;
            if (mlTab == this._activeTab) {
                mlSegmentArray2[n5].x2 += n6;
            }
            mlSegmentArray2[n5].y2 = mlTab.y + mlTab.height - n6 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray2[n5].x1 = n - mlSegmentArray2[n5].x1;
                mlSegmentArray2[n5].x2 = n - mlSegmentArray2[n5].x2;
            }
            ++n5;
            ++n6;
        }
        if (n4 > 0) {
            this.setDrawStyle(graphics, 1);
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        if (n5 > 0) {
            this.setDrawStyle(graphics, 0);
            MlUtil.drawSegments(graphics, mlSegmentArray2, n5);
            this.setDrawStyle(graphics, 3);
        }
        n4 = 0;
        n6 = 0;
        while (n6 < n2) {
            mlSegmentArray[n4].x1 = mlTab.x + n6;
            mlSegmentArray[n4].y1 = mlTab.y + n3 + n2;
            mlSegmentArray[n4].x2 = mlTab.x + n6;
            mlSegmentArray[n4].y2 = mlTab.y + mlTab.height - n3 - n2 - 1;
            if (this._tabPlacement == 3) {
                mlSegmentArray[n4].x1 = n - mlSegmentArray[n4].x1;
                mlSegmentArray[n4].x2 = n - mlSegmentArray[n4].x2;
            }
            ++n4;
            ++n6;
        }
        if (n4 > 0) {
            if (this._tabPlacement == 3) {
                this.setDrawStyle(graphics, 0);
            } else {
                this.setDrawStyle(graphics, 1);
            }
            MlUtil.drawSegments(graphics, mlSegmentArray, n4);
            this.setDrawStyle(graphics, 3);
        }
        rectangle.x = mlTab.x;
        rectangle.y = mlTab.y;
        rectangle.width = n3 + n2;
        rectangle.height = n3 + n2;
        if (this._tabPlacement == 3) {
            rectangle.x = mlTab.x + mlTab.width - rectangle.width;
        }
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setDrawStyle(graphics, 3);
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        int n9 = rectangle.width * 2;
        int n10 = rectangle.height * 2;
        if (this._serverDrawsArcsLarge) {
            --n9;
            --n10;
        }
        int n11 = 0;
        int n12 = 360;
        if (this._tabPlacement == 3) {
            n7 = mlTab.x + mlTab.width - n9;
        }
        this.setDrawStyle(graphics, 1);
        Graphics graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle);
        graphics2.fillArc(n7, n8, n9, n10, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
        this.setDrawStyle(graphics, 3);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.width -= n2;
        rectangle2.height -= n2;
        rectangle2.y += n2;
        if (this._tabPlacement == 2) {
            rectangle2.x += n2;
        }
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle2);
        graphics2.fillArc(n7 += n2, n8 += n2, n9 -= n2 * 2, n10 -= n2 * 2, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
        rectangle.y = mlTab.y + mlTab.height - n3 - n2;
        this.setDrawStyle(graphics, 2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setDrawStyle(graphics, 3);
        n7 = rectangle.x;
        n8 = rectangle.y - n3 - n2;
        n9 = rectangle.width * 2;
        n10 = rectangle.height * 2;
        if (this._serverDrawsArcsLarge) {
            --n9;
            --n10;
        }
        n11 = 0;
        n12 = 360;
        if (this._tabPlacement == 3) {
            n7 = mlTab.x + mlTab.width - n9;
        }
        this.setDrawStyle(graphics, 0);
        graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle);
        graphics2.fillArc(n7, n8, n9, n10, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
        this.setDrawStyle(graphics, 3);
        rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.width -= n2;
        rectangle2.height -= n2;
        if (this._tabPlacement == 2) {
            rectangle2.x += n2;
        }
        if (mlTab == this._activeTab) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this._inactiveBackground);
        }
        graphics2 = graphics.create();
        MlUtil.graphicsClipRect(graphics2, rectangle2);
        graphics2.fillArc(n7 += n2, n8 += n2, n9 -= n2 * 2, n10 -= n2 * 2, n11, n12);
        graphics2.drawArc(n7, n8, n9, n10, n11, n12);
        graphics2.dispose();
    }

    protected Object getTabValueByIndex(MlTab mlTab, int n) {
        switch (n) {
            case 105: {
                return mlTab.font;
            }
            case 106: {
                return mlTab.inactiveImage;
            }
            case 107: {
                return mlTab.image;
            }
            case 108: {
                return mlTab.label;
            }
        }
        return null;
    }

    protected long getTabValueMask(int n, long l) {
        switch (n) {
            case 105: {
                l |= 1L;
                break;
            }
            case 106: {
                l |= 2L;
                break;
            }
            case 107: {
                l |= 4L;
                break;
            }
            case 108: {
                l |= 8L;
            }
        }
        return l;
    }

    public synchronized Object getTabValue(String string, String string2) {
        int n = this.pageNameToPos(string);
        if (n < 0) {
            return null;
        }
        MlResource mlResource = this._resourceMap.lookupByName(string2);
        if (mlResource == null) {
            this.warning("getTabValue(): Unknown resource " + string2);
            return null;
        }
        return this.getTabValueByIndex(this._tabs[n], mlResource.index);
    }

    protected boolean setTabValues(MlTab mlTab, long l) {
        if ((l & 1L) > 0L) {
            mlTab.setFont(this._tabFont);
        }
        if ((l & 4L) > 0L) {
            mlTab.setImage(this._tabImage);
        }
        if ((l & 2L) > 0L) {
            mlTab.setInactiveImage(this._tabInactiveImage);
        }
        if ((l & 8L) > 0L) {
            mlTab.setLabel(this._tabLabel);
        }
        return true;
    }

    protected boolean setSubValues(MlResources mlResources) {
        boolean bl = false;
        int n = 0;
        int n2 = this._tabCount - 1;
        long l = 0L;
        int n3 = mlResources.getCount();
        int n4 = 0;
        while (n4 < n3) {
            MlResource mlResource = mlResources.getResource(n4);
            if (!mlResource.applied && mlResource.converted) {
                long l2 = this.getTabValueMask(mlResource.index, 0L);
                if (l2 > 0L) {
                    mlResource.applied = true;
                }
                l |= l2;
                switch (mlResource.index) {
                    case 104: {
                        n2 = n = this.pageNameToPos((String)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 105: {
                        this._tabFont = (Font)mlResource.value;
                        break;
                    }
                    case 106: {
                        this._tabInactiveImage = (Image)mlResource.value;
                        break;
                    }
                    case 107: {
                        this._tabImage = (Image)mlResource.value;
                        break;
                    }
                    case 108: {
                        this._tabLabel = (String)mlResource.value;
                    }
                }
            }
            ++n4;
        }
        if (l > 0L) {
            if (n < 0) {
                this.warning("setValues() - invalid tab(s) specified");
            } else {
                n4 = n;
                while (n4 <= n2) {
                    if (this.setTabValues(this._tabs[n4], l)) {
                        bl = true;
                    }
                    ++n4;
                }
            }
        }
        return bl;
    }

    public Object getValueByIndex(int n) {
        Object object = super.getValueByIndex(n);
        if (object != null) {
            return object;
        }
        switch (n) {
            case 4: {
                return new Integer(this._activeTabNum);
            }
            case 5: {
                return new Boolean(this._autoSelect);
            }
            case 6: {
                return this._blankBackground;
            }
            case 7: {
                return this._bottomShadowColor;
            }
            case 8: {
                return new Integer(this._cornerDimension);
            }
            case 9: {
                return new Integer(this._cornerStyle);
            }
            case 10: {
                return new Integer(this._debugLevel);
            }
            case 11: {
                return this._highlightColor;
            }
            case 12: {
                return new Integer(this._highlightThickness);
            }
            case 13: {
                return new Integer(this._imageMargin);
            }
            case 14: {
                return this._inactiveBackground;
            }
            case 15: {
                return this._inactiveForeground;
            }
            case 16: {
                return new Integer(this._marginHeight);
            }
            case 17: {
                return new Integer(this._marginWidth);
            }
            case 19: {
                return new Integer(this._shadowThickness);
            }
            case 20: {
                return new Integer(this._spacing);
            }
            case 21: {
                return new Integer(this._tabBarHeight);
            }
            case 22: {
                return new Integer(this._tabCount);
            }
            case 23: {
                return new Integer(this._tabPlacement);
            }
            case 24: {
                return new Integer(this._tabsPerRow);
            }
            case 25: {
                return this._topShadowColor;
            }
        }
        return null;
    }

    protected synchronized void setValuesConverted(MlResources mlResources) {
        super.setValuesConverted(mlResources);
        int n = mlResources.getCount();
        int n2 = 0;
        while (n2 < n) {
            MlResource mlResource = mlResources.getResource(n2);
            if (!mlResource.applied && mlResource.converted) {
                int n3 = 0;
                if (mlResource.type == 1) {
                    n3 = (Integer)mlResource.value;
                }
                boolean bl = false;
                if (mlResource.type == 3) {
                    bl = (Boolean)mlResource.value;
                }
                switch (mlResource.index) {
                    case 5: {
                        this.setAutoSelect(bl);
                        mlResource.applied = true;
                        break;
                    }
                    case 6: {
                        this.setBlankBackground((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 7: {
                        this.setBottomShadowColor((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 8: {
                        this.setCornerDimension(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 9: {
                        this.setCornerStyle(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 10: {
                        this.setDebugLevel(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 11: {
                        this.setHighlightColor((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 12: {
                        this.setHighlightThickness(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 13: {
                        this.setImageMargin(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 14: {
                        this.setInactiveBackground((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 15: {
                        this.setInactiveForeground((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 16: {
                        this.setMarginHeight(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 17: {
                        this.setMarginWidth(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 19: {
                        this.setShadowThickness(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 20: {
                        this.setSpacing(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 23: {
                        this.setTabPlacement(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 24: {
                        this.setTabsPerRow(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 25: {
                        this.setTopShadowColor((Color)mlResource.value);
                        mlResource.applied = true;
                    }
                }
            }
            ++n2;
        }
        if (this.setSubValues(mlResources)) {
            this.doLayout(true);
            this.draw();
        }
    }

    protected void traverse(boolean bl, AWTEvent aWTEvent) {
        if (this._tabCount == 0) {
            return;
        }
        int n = this.findTabNum(this._focusTab);
        n = bl ? ++n : --n;
        if (n < 0) {
            n = this._tabCount - 1;
        }
        if (n >= this._tabCount) {
            n = 0;
        }
        this.setFocusTab(this._tabs[n], aWTEvent);
    }

    protected int findTabNum(MlTab mlTab) {
        int n = 0;
        while (n < this._tabCount) {
            if (mlTab == this._tabs[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int pageNameToPos(String string) {
        int n = 0;
        while (n < this._tabCount) {
            if (string.equals(this._tabs[n].pageName)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void setFocusTab(MlTab mlTab, AWTEvent aWTEvent) {
        Graphics graphics;
        if (this._focusTab == mlTab) {
            return;
        }
        MlTab mlTab2 = this._focusTab;
        this._focusTab = mlTab;
        if (mlTab2 != null && this.isShowing()) {
            graphics = this.getGraphics();
            this.drawTabHighlight(graphics, mlTab2);
            graphics.dispose();
        }
        if (mlTab != null && this.isShowing()) {
            graphics = this.getGraphics();
            this.drawTabHighlight(graphics, mlTab);
            graphics.dispose();
        }
    }

    protected void showPage(MlTab mlTab, boolean bl) {
        Rectangle rectangle;
        if (this._activeTab == mlTab) {
            return;
        }
        int n = this.findTabNum(mlTab);
        if (this._debugLevel > 0) {
            System.out.println("TabPanel: post activated " + n);
        }
        MlTab mlTab2 = this._activeTab;
        this._activeTab = mlTab;
        this._activeTabNum = n;
        if (this.isShowing() && mlTab2 != null) {
            rectangle = this.getTabRect(mlTab2, true);
            this.addDirtyRect(rectangle);
        }
        if (this._activeTab == null) {
            return;
        }
        if (this._tabsPerRow > 0 && mlTab.row != this._activeRow) {
            this.doLayout(false);
            this.draw();
        }
        this._allowLayout = false;
        if (this.getLayout() instanceof CardLayout) {
            ((CardLayout)this.getLayout()).show(this, mlTab.pageName);
        }
        this._allowLayout = true;
        if (this.isShowing()) {
            rectangle = this.getTabRect(mlTab, true);
            this.addDirtyRect(rectangle);
        }
        if (bl) {
            String string = mlTab.pageName;
            this.dispatchEvent(new MlTabPanelEvent((Object)this, string));
        }
    }

    protected void initTabPanelProperties() {
        this._activeTabNum = -1;
        this._autoSelect = true;
        this._blankBackground = new Color(192, 192, 192);
        this._bottomShadowColor = new Color(40, 40, 40);
        this._cornerDimension = 2;
        this._cornerStyle = 2;
        this._debugLevel = 0;
        this._highlightColor = new Color(0, 0, 0);
        this._highlightThickness = 1;
        this._imageMargin = 2;
        this._inactiveBackground = this._blankBackground;
        this._inactiveForeground = new Color(0, 0, 0);
        this._marginHeight = 1;
        this._marginWidth = 1;
        this._shadowThickness = 2;
        this._spacing = 0;
        this._tabBarHeight = 0;
        this._tabCount = 0;
        this._tabPlacement = 0;
        this._tabsPerRow = 0;
        this._topShadowColor = new Color(255, 255, 255);
    }

    public int getActiveTabNum() {
        return this._activeTabNum;
    }

    public boolean getAutoSelect() {
        return this._autoSelect;
    }

    public void setAutoSelect(boolean bl) {
        this._autoSelect = bl;
    }

    public Color getBlankBackground() {
        return this._blankBackground;
    }

    public void setBlankBackground(Color color) {
        this._blankBackground = color;
        this.draw();
    }

    public Color getBottomShadowColor() {
        return this._bottomShadowColor;
    }

    public void setBottomShadowColor(Color color) {
        this._bottomShadowColor = color;
        this.draw();
    }

    public int getCornerDimension() {
        return this._cornerDimension;
    }

    public void setCornerDimension(int n) {
        this._cornerDimension = n;
        this.doLayout();
        this.draw();
    }

    public int getCornerStyle() {
        return this._cornerStyle;
    }

    public void setCornerStyle(int n) {
        this._cornerStyle = n;
        this.doLayout();
        this.draw();
    }

    public int getDebugLevel() {
        return this._debugLevel;
    }

    public void setDebugLevel(int n) {
        this._debugLevel = n;
    }

    public Color getHighlightColor() {
        return this._highlightColor;
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
        this.draw();
    }

    public int getHighlightThickness() {
        return this._highlightThickness;
    }

    public void setHighlightThickness(int n) {
        this._highlightThickness = n;
        this.doLayout();
        this.draw();
    }

    public int getImageMargin() {
        return this._imageMargin;
    }

    public void setImageMargin(int n) {
        this._imageMargin = n;
        this.doLayout();
        this.draw();
    }

    public Color getInactiveBackground() {
        return this._inactiveBackground;
    }

    public void setInactiveBackground(Color color) {
        this._inactiveBackground = color;
        this.draw();
    }

    public Color getInactiveForeground() {
        return this._inactiveForeground;
    }

    public void setInactiveForeground(Color color) {
        this._inactiveForeground = color;
        this.draw();
    }

    public int getMarginHeight() {
        return this._marginHeight;
    }

    public void setMarginHeight(int n) {
        this._marginHeight = n;
        this.doLayout();
        this.draw();
    }

    public int getMarginWidth() {
        return this._marginWidth;
    }

    public void setMarginWidth(int n) {
        this._marginWidth = n;
        this.doLayout();
        this.draw();
    }

    public int getShadowThickness() {
        return this._shadowThickness;
    }

    public void setShadowThickness(int n) {
        this._shadowThickness = n;
        this.doLayout();
        this.draw();
    }

    public int getSpacing() {
        return this._spacing;
    }

    public void setSpacing(int n) {
        this._spacing = n;
        this.doLayout();
        this.draw();
    }

    public int getTabBarHeight() {
        return this._tabBarHeight;
    }

    public int getTabCount() {
        return this._tabCount;
    }

    public int getTabPlacement() {
        return this._tabPlacement;
    }

    public void setTabPlacement(int n) {
        this._tabPlacement = n;
        this.doLayout();
        this.draw();
    }

    public int getTabsPerRow() {
        return this._tabsPerRow;
    }

    public void setTabsPerRow(int n) {
        this._tabsPerRow = n;
        this.doLayout();
        this.draw();
    }

    public Color getTopShadowColor() {
        return this._topShadowColor;
    }

    public void setTopShadowColor(Color color) {
        this._topShadowColor = color;
        this.draw();
    }

    public synchronized void addMlTabPanelListener(MlTabPanelListener mlTabPanelListener) {
        MlTabPanelListener mlTabPanelListener2;
        MlTabPanelListener mlTabPanelListener3 = mlTabPanelListener2 = this._tabPanelListener;
        MlTabPanelListener mlTabPanelListener4 = mlTabPanelListener;
        this._tabPanelListener = mlTabPanelListener3 == null ? mlTabPanelListener4 : (mlTabPanelListener4 == null ? mlTabPanelListener3 : new MlEventMulticaster(mlTabPanelListener3, mlTabPanelListener4));
    }

    public synchronized void removeMlTabPanelListener(MlTabPanelListener mlTabPanelListener) {
        MlTabPanelListener mlTabPanelListener2 = this._tabPanelListener;
        MlTabPanelListener mlTabPanelListener3 = mlTabPanelListener2;
        MlTabPanelListener mlTabPanelListener4 = mlTabPanelListener;
        this._tabPanelListener = (MlTabPanelListener)(mlTabPanelListener3 == mlTabPanelListener4 || mlTabPanelListener3 == null ? null : (mlTabPanelListener3 instanceof MlEventMulticaster ? ((MlEventMulticaster)mlTabPanelListener3).remove(mlTabPanelListener4) : mlTabPanelListener3));
    }

    private void notifySelect(String string) {
        this.dispatchEvent(new MlTabPanelEvent((Object)this, string));
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MlTabPanelEvent) {
            this.processMlTabPanelEvent((MlTabPanelEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processMlTabPanelEvent(MlTabPanelEvent mlTabPanelEvent) {
        if (this._tabPanelListener != null) {
            this._tabPanelListener.onTabSelect(mlTabPanelEvent);
        }
    }

    public Component addPage(Component component) {
        return super.add("__page" + this._pageCount++, component);
    }

    public Component addTab(String string) {
        return this.addTab(string, null);
    }

    public Component addTab(String string, Image image) {
        return this.add(string, string, image, null);
    }

    public Component add(String string, Component component) {
        return this.add(string, string, null, component);
    }

    public Component add(String string, Image image, Component component) {
        return this.add(string, string, image, component);
    }

    public synchronized Component add(String string, String string2, Image image, Component component) {
        MlTab mlTab = new MlTab(this);
        mlTab.pageComponent = component;
        mlTab.pageName = string;
        mlTab.setFont(this.getFont());
        mlTab.setLabel(string2);
        mlTab.setImage(image);
        mlTab.setInactiveImage(image);
        if (this._tabAllocCount < this._tabCount + 1) {
            this._tabAllocCount *= 2;
            MlTab[] mlTabArray = new MlTab[this._tabAllocCount];
            int n = 0;
            while (n < this._tabs.length) {
                mlTabArray[n] = this._tabs[n];
                ++n;
            }
            this._tabs = mlTabArray;
        }
        this._tabs[this._tabCount++] = mlTab;
        this.invalidate();
        if (component == null) {
            return null;
        }
        return super.add(string, component);
    }

    public void remove(String string) {
        this.remove(this.pageNameToPos(string));
    }

    public synchronized void remove(int n) {
        if (n < 0 || n >= this._tabCount) {
            this.warning("TabPanel: remove passed invalid value");
            return;
        }
        MlTab mlTab = this._tabs[n];
        if (mlTab == this._activeTab) {
            this._activeTab = null;
            this._activeTabNum = -1;
        }
        int n2 = n;
        while (n2 < this._tabCount - 1) {
            this._tabs[n2] = this._tabs[n2 + 1];
            ++n2;
        }
        this._tabs[this._tabCount - 1] = null;
        --this._tabCount;
        this.invalidate();
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null && mlTab.pageComponent != null) {
            layoutManager.removeLayoutComponent(mlTab.pageComponent);
        }
    }

    public void showPage(String string) {
        this.showPage(string, true);
    }

    public synchronized void showPage(String string, boolean bl) {
        this.showPage(this.pageNameToPos(string), bl);
    }

    public synchronized void showPage(int n, boolean bl) {
        if (n < 0 || n >= this._tabCount) {
            this.warning("TabPanel: showPage passed invalid value");
            return;
        }
        this.showPage(this._tabs[n], bl);
    }
}

